<?php
session_start();
if(!isset($_SESSION['id_admin'])){
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit();
}

require_once("../includes/db_connect.php");

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Ambil data dari POST
    $id_janji = isset($_POST['id_janji']) ? intval($_POST['id_janji']) : 0;
    
    if($id_janji <= 0) {
        echo json_encode(['status' => 'error', 'message' => 'ID Janji tidak valid']);
        exit();
    }
    
    // Ambil data janji temu dari database
    $query = "SELECT j.id_pasien, j.id_layanan, p.nama_pasien, l.nama_layanan, j.tanggal_janji
              FROM janji_temu j
              JOIN data_diri_pasien p ON j.id_pasien = p.id_pasien
              JOIN jenis_layanan l ON j.id_layanan = l.id_layanan
              WHERE j.id_janji = ?";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id_janji);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows === 0) {
        echo json_encode(['status' => 'error', 'message' => 'Data janji tidak ditemukan']);
        exit();
    }
    
    $janji = $result->fetch_assoc();
    $stmt->close();
    
    // Ambil id_pegawai dari session admin atau default
    $id_pegawai = 1; // Ganti dengan id_pegawai yang sesuai, atau ambil dari session
    
    // Data default untuk rekam medis
    $data = [
        'id_pasien' => $janji['id_pasien'],
        'id_layanan' => $janji['id_layanan'],
        'keluhan' => 'Periksa rutin - ' . $janji['nama_layanan'],
        'tindakan' => 'Pemeriksaan awal',
        'hasil' => 'Dalam pemeriksaan',
        'tanggal_periksa' => date('Y-m-d'),
        'id_pegawai' => $id_pegawai
    ];
    
    // Cek apakah sudah ada rekam medis untuk janji ini hari ini
    $check_query = "SELECT id_rekam FROM rekam_medis 
                    WHERE id_pasien = ? AND id_layanan = ? 
                    AND tanggal_periksa = ?";
    $check_stmt = $conn->prepare($check_query);
    $check_stmt->bind_param("iis", 
        $data['id_pasien'], 
        $data['id_layanan'], 
        $data['tanggal_periksa']
    );
    $check_stmt->execute();
    $check_result = $check_stmt->get_result();
    
    if($check_result->num_rows > 0) {
        echo json_encode([
            'status' => 'warning', 
            'message' => 'Rekam medis untuk pasien ini sudah ada hari ini'
        ]);
        exit();
    }
    
    // Insert ke tabel rekam_medis
    $insert_query = "INSERT INTO rekam_medis 
                    (id_pasien, id_layanan, keluhan, tindakan, hasil, tanggal_periksa, id_pegawai) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)";
    
    $insert_stmt = $conn->prepare($insert_query);
    $insert_stmt->bind_param("iissssi",
        $data['id_pasien'],
        $data['id_layanan'],
        $data['keluhan'],
        $data['tindakan'],
        $data['hasil'],
        $data['tanggal_periksa'],
        $data['id_pegawai']
    );
    
    if($insert_stmt->execute()) {
        $id_rekam = $conn->insert_id;
        
        // Update status janji menjadi 'selesai'
        $update_query = "UPDATE janji_temu SET status = 'selesai' WHERE id_janji = ?";
        $update_stmt = $conn->prepare($update_query);
        $update_stmt->bind_param("i", $id_janji);
        $update_stmt->execute();
        $update_stmt->close();
        
        echo json_encode([
            'status' => 'success',
            'message' => 'Rekam medis berhasil dibuat',
            'data' => [
                'id_rekam' => $id_rekam,
                'pasien' => $janji['nama_pasien'],
                'layanan' => $janji['nama_layanan']
            ]
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Gagal menyimpan rekam medis: ' . $conn->error
        ]);
    }
    
    $insert_stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>