<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>

<div class="page-jadwal">
    <h2>🗓️ Jadwal Kerja Dokter</h2>
    <p>Atur jadwal dokter yang siap melayani pasien kecil kita 💙</p>

    <div class="jadwal-container">
        <!-- Form Tambah Jadwal -->
        <div class="jadwal-form">
            <h3><i class="bx bx-plus-circle"></i> Tambah Jadwal</h3>
            <form id="formJadwal">
                <label>Nama Dokter:</label>
                <input type="text" name="nama_dokter" placeholder="Masukkan nama dokter..." required>

                <label>Hari:</label>
                <select name="hari" required>
                    <option value="">Pilih Hari</option>
                    <option>Senin</option>
                    <option>Selasa</option>
                    <option>Rabu</option>
                    <option>Kamis</option>
                    <option>Jumat</option>
                    <option>Sabtu</option>
                </select>

                <label>Jam Mulai:</label>
                <input type="time" name="jam_mulai" required>

                <label>Jam Selesai:</label>
                <input type="time" name="jam_selesai" required>

                <button type="submit" class="btn-save"><i class="bx bx-save"></i> Simpan</button>
            </form>
        </div>

        <!-- Tabel Jadwal -->
        <div class="jadwal-list">
            <h3><i class="bx bx-calendar"></i> Daftar Jadwal</h3>
            <table>
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Dokter</th>
                        <th>Hari</th>
                        <th>Jam Mulai</th>
                        <th>Jam Selesai</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody id="jadwalData">
                    <tr>
                        <td>1</td>
                        <td>drg. Sinta</td>
                        <td>Senin</td>
                        <td>09:00</td>
                        <td>12:00</td>
                        <td>
                            <button class="btn-edit"><i class="bx bx-edit"></i></button>
                            <button class="btn-delete"><i class="bx bx-trash"></i></button>
                        </td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>drg. Adit</td>
                        <td>Selasa</td>
                        <td>10:00</td>
                        <td>13:00</td>
                        <td>
                            <button class="btn-edit"><i class="bx bx-edit"></i></button>
                            <button class="btn-delete"><i class="bx bx-trash"></i></button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    const form = document.getElementById('formJadwal');
    const table = document.getElementById('jadwalData');

    form.addEventListener('submit', (e) => {
        e.preventDefault();
        const nama = form.nama_dokter.value;
        const hari = form.hari.value;
        const mulai = form.jam_mulai.value;
        const selesai = form.jam_selesai.value;

        const newRow = document.createElement('tr');
        newRow.innerHTML = `
      <td>${table.rows.length + 1}</td>
      <td>${nama}</td>
      <td>${hari}</td>
      <td>${mulai}</td>
      <td>${selesai}</td>
      <td>
        <button class="btn-edit"><i class="bx bx-edit"></i></button>
        <button class="btn-delete"><i class="bx bx-trash"></i></button>
      </td>
    `;
        table.appendChild(newRow);
        form.reset();
    });

    // Hapus jadwal
    document.addEventListener('click', (e) => {
        if (e.target.closest('.btn-delete')) {
            e.target.closest('tr').remove();
        }
    });
</script>
