<?php
session_start();
if(!isset($_SESSION['id_admin'])){
    header("Location: ../login_admin.php");
    exit();
}
require_once("../includes/db_connect.php");

// Ambil tanggal hari ini
$today = date('Y-m-d');

// Query untuk janji hari ini dengan JOIN ke tabel antrian
$q_hari_ini = $conn->query("
    SELECT j.id_janji, p.nama_pasien, l.nama_layanan,
    j.tanggal_janji, j.status, j.catatan, 
    a.kode_unik, a.nomor_antrian
    FROM janji_temu j
    LEFT JOIN data_diri_pasien p ON j.id_pasien = p.id_pasien
    LEFT JOIN jenis_layanan l ON j.id_layanan = l.id_layanan
    LEFT JOIN antrian a ON j.id_janji = a.id_janji
    WHERE DATE(j.tanggal_janji) = '$today'
    ORDER BY j.tanggal_janji ASC
");

// Query untuk semua janji (dengan filter search jika ada)
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';

$query_semua = "
    SELECT j.id_janji, p.nama_pasien, l.nama_layanan,
    j.tanggal_janji, j.status, j.catatan, 
    a.kode_unik, a.nomor_antrian
    FROM janji_temu j
    LEFT JOIN data_diri_pasien p ON j.id_pasien = p.id_pasien
    LEFT JOIN jenis_layanan l ON j.id_layanan = l.id_layanan
    LEFT JOIN antrian a ON j.id_janji = a.id_janji
";

if(!empty($search)) {
    $query_semua .= " WHERE 
        a.kode_unik LIKE '%$search%' OR 
        p.nama_pasien LIKE '%$search%' OR 
        l.nama_layanan LIKE '%$search%' OR
        a.nomor_antrian LIKE '%$search%'
    ";
}

$query_semua .= " ORDER BY j.tanggal_janji DESC";

$q_semua = $conn->query($query_semua);

$statusColors = [
    "menunggu" => "#f1c40f",
    "disetujui" => "#2ecc71",
    "selesai" => "#3498db",
    "batal" => "#e74c3c"
];
?>

<div class="page-janji">
    <h2>📅 Kelola Janji Temu</h2>
    <p>Atur dan verifikasi janji pasien yang sudah mendaftar periksa gigi.</p>

    <div class="action-bar">
        <button class="btn-primary" id="btnTambahJanji">➕ Tambah Janji</button>
        <button class="btn-refresh" id="btnRefresh">🔄 Refresh</button>

        <!-- Form Search Kode Unik -->
        <div class="search-container">
            <form method="GET" action="" class="search-form">
                <input type="text" name="search" placeholder="🔍 Cari kode unik, nama, atau layanan..."
                    value="<?php echo htmlspecialchars($search); ?>" class="search-input">
                <button type="submit" class="btn-search">Cari</button>
                <?php if(!empty($search)): ?>
                <a href="?" class="btn-clear">Clear</a>
                <?php endif; ?>
            </form>
        </div>
    </div>

    <!-- Bagian 1: Janji Hari Ini -->
    <div class="section-janji">
        <h3 class="section-title">📌 Janji Temu Hari Ini (<?php echo date('d M Y'); ?>)</h3>
        <div class="table-container">
            <table class="table-cute">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Kode Unik</th>
                        <th>Nama Pasien</th>
                        <th>Layanan</th>
                        <th>Waktu</th>
                        <th>Status</th>
                        <th>Catatan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($q_hari_ini->num_rows > 0): ?>
                    <?php $no = 1; while ($row = $q_hari_ini->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $no++; ?></td>
                        <td>
                            <span class="kode-unik-badge" onclick="copyToClipboard('<?php echo $row['kode_unik']; ?>')"
                                title="Klik untuk menyalin">
                                <?php echo $row['kode_unik'] ?: '-'; ?>
                            </span>
                        </td>
                        <td><?php echo $row['nama_pasien']; ?></td>
                        <td><?php echo $row['nama_layanan']; ?></td>
                        <td><?php echo date('H:i', strtotime($row['tanggal_janji'])); ?></td>
                        <td>
                            <select class='status-badge' data-id='<?php echo $row['id_janji']; ?>'>
                                <option value='menunggu' <?php echo ($row['status']=='menunggu'?'selected':''); ?>>
                                    Menunggu</option>
                                <option value='disetujui' <?php echo ($row['status']=='disetujui'?'selected':''); ?>>
                                    Disetujui</option>
                                <option value='selesai' <?php echo ($row['status']=='selesai'?'selected':''); ?>>Selesai
                                </option>
                                <option value='batal' <?php echo ($row['status']=='batal'?'selected':''); ?>>Batal
                                </option>
                            </select>
                        </td>
                        <td><?php echo ($row['catatan'] ?: '-'); ?></td>
                        <td>
                            <button onclick="autoSaveRekamMedis(<?php echo $row['id_janji']; ?>, this)"
                                class="btn-rekam"
                                style="background-color: #28a745; color: white; padding: 5px 10px; text-decoration: none; border-radius: 4px; font-size: 12px; border: none; cursor: pointer;">
                                📋 Lakukan pemeriksaan
                            </button>
                            <button onclick='hapusJanji(<?php echo $row['id_janji']; ?>)'>🗑️</button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="8" align="center">Tidak ada janji temu untuk hari ini.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bagian 2: Semua Janji Temu -->
    <div class="section-janji">
        <h3 class="section-title">📋 Semua Janji Temu</h3>
        <?php if(!empty($search)): ?>
        <div class="search-info">
            Hasil pencarian untuk: <strong>"<?php echo htmlspecialchars($search); ?>"</strong>
            (<?php echo $q_semua->num_rows; ?> hasil ditemukan)
        </div>
        <?php endif; ?>

        <div class="table-container">
            <table class="table-cute">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Kode Unik</th>
                        <th>Nama Pasien</th>
                        <th>Layanan</th>
                        <th>Tanggal</th>
                        <th>Waktu</th>
                        <th>Status</th>
                        <th>Catatan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($q_semua->num_rows > 0): ?>
                    <?php $no = 1; while ($row = $q_semua->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $no++; ?></td>
                        <td>
                            <span class="kode-unik-badge" onclick="copyToClipboard('<?php echo $row['kode_unik']; ?>')"
                                title="Klik untuk menyalin">
                                <?php echo $row['kode_unik'] ?: '-'; ?>
                            </span>
                        </td>
                        <td><?php echo $row['nama_pasien']; ?></td>
                        <td><?php echo $row['nama_layanan']; ?></td>
                        <td><?php echo date('d M Y', strtotime($row['tanggal_janji'])); ?></td>
                        <td><?php echo date('H:i', strtotime($row['tanggal_janji'])); ?></td>
                        <td>
                            <select class='status-badge' data-id='<?php echo $row['id_janji']; ?>'>
                                <option value='menunggu' <?php echo ($row['status']=='menunggu'?'selected':''); ?>>
                                    Menunggu</option>
                                <option value='disetujui' <?php echo ($row['status']=='disetujui'?'selected':''); ?>>
                                    Disetujui</option>
                                <option value='selesai' <?php echo ($row['status']=='selesai'?'selected':''); ?>>Selesai
                                </option>
                                <option value='batal' <?php echo ($row['status']=='batal'?'selected':''); ?>>Batal
                                </option>
                            </select>
                        </td>
                        <td><?php echo ($row['catatan'] ?: '-'); ?></td>
                        <td>
                            <button onclick='showEdit(<?php echo $row['id_janji']; ?>)'>✏️</button>
                            <button onclick='hapusJanji(<?php echo $row['id_janji']; ?>)'>🗑️</button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="9" align="center">
                            <?php echo empty($search) ? 'Belum ada janji temu.' : 'Tidak ditemukan janji temu dengan kata kunci tersebut.'; ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Tambah (DIMODIFIKASI untuk generate kode unik) -->
<!-- Modal Tambah -->
<div class="modal" id="modalTambahJanji">
    <div class="modal-content">
        <span class="close" onclick="closeModal('modalTambahJanji')">&times;</span>
        <h3>Tambah Janji Temu</h3>
        <form id="formTambahJanji">
            <label>Nama Pasien</label>
            <select name="id_pasien" required>
                <option value="">-- Pilih Pasien --</option>
                <?php
                $res = $conn->query("SELECT id_pasien,nama_pasien FROM data_diri_pasien ORDER BY nama_pasien ASC");
                while($p = $res->fetch_assoc()){
                    echo "<option value='{$p['id_pasien']}'>{$p['nama_pasien']}</option>";
                }
                ?>
            </select>

            <label>Layanan</label>
            <select name="id_layanan" required>
                <option value="">-- Pilih Layanan --</option>
                <?php
                $res = $conn->query("SELECT id_layanan,nama_layanan FROM jenis_layanan ORDER BY nama_layanan ASC");
                while($l = $res->fetch_assoc()){
                    echo "<option value='{$l['id_layanan']}'>{$l['nama_layanan']}</option>";
                }
                ?>
            </select>

            <label>Tanggal</label>
            <input type="date" name="tanggal_janji" required>

            <label>Status</label>
            <select name="status" required>
                <option>menunggu</option>
                <option>terverifikasi</option>
                <option>selesai</option>
                <option>dibatalkan</option>
            </select>

            <label>Catatan</label>
            <textarea name="catatan"></textarea>

            <button type="submit" class="btn-primary full">Simpan</button>
        </form>
    </div>
</div>

<!-- Modal Edit -->
<div class="modal" id="modalEditJanji">
    <div class="modal-content">
        <span class="close" onclick="closeModal('modalEditJanji')">&times;</span>
        <h3>Edit Janji Temu</h3>
        <form id="formEditJanji">
            <input type="hidden" name="id_janji">
            <label>Tanggal</label>
            <input type="date" name="tanggal_janji" required>

            <label>Status</label>
            <select name="status" required>
                <option>menunggu</option>
                <option>terverifikasi</option>
                <option>selesai</option>
                <option>dibatalkan</option>
            </select>

            <label>Catatan</label>
            <textarea name="catatan"></textarea>

            <button type="submit" class="btn-primary full">Simpan Perubahan</button>
        </form>
    </div>
</div>

<style>
    .status-tag {
        appearance: none;
        /* hilangkan default dropdown */
        -webkit-appearance: none;
        -moz-appearance: none;
        padding: 5px 10px;
        border-radius: 12px;
        border: none;
        color: #fff;
        font-weight: bold;
        cursor: pointer;
    }

    .status-tag option {
        color: #000;
        /* opsional, saat dropdown dibuka */
    }

    /* ---------- MODAL BACKDROP ---------- */
    .modal {
        display: none;
        /* default hidden */
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        justify-content: center;
        align-items: center;
        z-index: 9999;
        overflow-y: auto;
        padding: 20px;
    }

    /* Show modal */
    .modal.show {
        display: flex;
        animation: fadeIn 0.2s ease-in;
    }

    /* ---------- MODAL CONTENT ---------- */
    .modal-content {
        background: #fff;
        border-radius: 12px;
        padding: 25px 20px;
        max-width: 500px;
        width: 100%;
        position: relative;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
        animation: slideIn 0.2s ease-out;
    }

    /* ---------- CLOSE BUTTON ---------- */
    .modal-content .close {
        position: absolute;
        top: 12px;
        right: 15px;
        font-size: 22px;
        font-weight: bold;
        cursor: pointer;
        color: #333;
        transition: color 0.2s;
    }

    .modal-content .close:hover {
        color: #e74c3c;
    }

    /* ---------- FORM ELEMENTS ---------- */
    .modal-content label {
        display: block;
        margin: 10px 0 5px;
        font-weight: 500;
        color: #333;
    }

    .modal-content input[type="text"],
    .modal-content input[type="date"],
    .modal-content input[type="time"],
    .modal-content select,
    .modal-content textarea {
        width: 100%;
        padding: 8px 10px;
        border-radius: 6px;
        border: 1px solid #ccc;
        margin-bottom: 12px;
        box-sizing: border-box;
        transition: border-color 0.2s;
    }

    .modal-content input:focus,
    .modal-content select:focus,
    .modal-content textarea:focus {
        outline: none;
        border-color: #3498db;
    }

    /* ---------- BUTTONS ---------- */
    .modal-content button {
        padding: 10px 15px;
        background: #3498db;
        color: #fff;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-weight: 500;
        transition: background 0.2s;
    }

    .modal-content button:hover {
        background: #2980b9;
    }

    /* ---------- FULL WIDTH BUTTON ---------- */
    .modal-content .full {
        width: 100%;
        margin-top: 10px;
    }

    /* ---------- ANIMATIONS ---------- */
    @keyframesfadeIn {
        from{ opacity: 0;
    }

    to {
        opacity: 1;
    }
    }

    @keyframesslideIn{
    from {
        transform: translateY(-20px);
        opacity: 0;
    }

    to {
        transform: translateY(0);
        opacity: 1;
    }
    }

    /* ---------- RESPONSIVE ---------- */
    @media(max-width:576px){.modal-content {
        padding: 20px 15px;
    }
    }
</style>

<script>
    function openModal(id) {
        document.getElementById(id).classList.add("show");
    }

    function closeModal(id) {
        document.getElementById(id).classList.remove("show");
    }

    function loadJanji() {
        fetch("proses_janji/load.php")
            .then(res => res.json())
            .then(data => {
                const tbody = document.querySelector("#tabelJanji tbody");
                tbody.innerHTML = "";
                if (data.length === 0) {
                    tbody.innerHTML = "<tr><td colspan='7' align='center'>Belum ada janji temu.</td></tr>";
                    return;
                }
                let no = 1;
                data.forEach(row => {
                    tbody.innerHTML += `
                <tr>
                    <td>${no++}</td>
                    <td>${row.nama_pasien}</td>
                    <td>${row.nama_layanan}</td>
                    <td>${row.tanggal_janji}</td>
                    <td>
                        <select class='status-badge' data-id='${row.id_janji}'>
                            <option value='menunggu' ${row.status=='menunggu'?'selected':''}>Menunggu</option>
                            <option value='disetujui' ${row.status=='disetujui'?'selected':''}>Disetujui</option>
                            <option value='selesai' ${row.status=='selesai'?'selected':''}>Selesai</option>
                            <option value='batal' ${row.status=='batal'?'selected':''}>Batal</option>
                        </select>
                    </td>
                    <td>${row.catatan || '-'}</td>
                    <td>
                        <button onclick="showEdit(${row.id_janji})">✏️</button>
                        <button onclick="hapusJanji(${row.id_janji})">🗑️</button>
                    </td>
                </tr>
            `;
                });

                // ✅ Tambahkan event listener setelah tabel dimuat
                document.querySelectorAll('.status-badge').forEach(select => {
                    select.addEventListener('change', function () {
                        const id = this.dataset.id;
                        const status = this.value;

                        fetch('proses_janji/update_status.php', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/x-www-form-urlencoded'
                                },
                                body: 'id_janji=' + id + '&status=' + status
                            })
                            .then(res => res.text())
                            .then(res => {
                                if (res.trim() !== 'success') alert('Gagal update status: ' +
                                    res);
                            });
                    });
                });

            });
    }


    document.getElementById("btnTambahJanji").onclick = () => openModal('modalTambahJanji');

    document.getElementById("formTambahJanji").onsubmit = e => {
        e.preventDefault();
        const fd = new FormData(e.target);
        fetch("proses_janji_admin/tambah.php", {
                method: "POST",
                body: fd
            })
            .then(res => res.text())
            .then(res => {
                if (res === "success") {
                    closeModal('modalTambahJanji');
                    loadJanji();
                } else alert("Gagal menambah janji");
            });
    }

    function showEdit(id) {
        fetch(`proses_janji_admin/edit.php?id=${id}`)
            .then(res => res.json())
            .then(data => {
                const f = document.getElementById("formEditJanji");
                f.id_janji.value = data.id_janji;
                f.tanggal_janji.value = data.tanggal_janji;
                f.status.value = data.status;
                f.catatan.value = data.catatan;
                openModal('modalEditJanji');
            });
    }

    document.getElementById("formEditJanji").onsubmit = e => {
        e.preventDefault();
        const fd = new FormData(e.target);
        fetch("proses_janji_admin/edit.php", {
                method: "POST",
                body: fd
            })
            .then(res => res.text())
            .then(res => {
                if (res === "success") {
                    closeModal('modalEditJanji');
                    loadJanji();
                } else alert("Gagal update janji");
            });
    }

    function hapusJanji(id) {
        if (!confirm("Hapus janji ini?")) return;
        fetch("proses_janji_admin/delete.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: "id=" + id
            })
            .then(res => res.text())
            .then(res => {
                if (res === "success") loadJanji();
            });
    }

    document.addEventListener("DOMContentLoaded", loadJanji);
</script>

<script>
    document.querySelectorAll('.status-badge').forEach(select => {
        select.addEventListener('change', function () {
            const id = this.dataset.id;
            const status = this.value;

            if (!confirm('Apakah Anda ingin mengubah status ini?')) {
                // Batalkan perubahan
                this.value = this.getAttribute('data-original');
                return;
            }

            fetch('admin/proses_janji/update_status.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: 'id_janji=' + id + '&status=' + status
                })
                .then(res => res.text())
                .then(res => {
                    if (res.trim() === 'success') {
                        alert('✅ Status berhasil diubah!');
                        this.setAttribute('data-original', status); // update nilai asli
                    } else {
                        alert('❌ Gagal update status: ' + res);
                        this.value = this.getAttribute('data-original'); // rollback
                    }
                });
        });

        // Simpan status awal untuk rollback bila cancel
        select.setAttribute('data-original', select.value);
    });

    function autoSaveRekamMedis(id_janji, buttonElement) {
    if(!confirm('Lanjutkan ke rekam medis untuk janji ini?')) {
        return;
    }
    
    // Tampilkan loading state
    const originalText = buttonElement.innerHTML;
    buttonElement.innerHTML = '⏳ Memproses...';
    buttonElement.disabled = true;
    buttonElement.style.backgroundColor = '#6c757d';
    
    // Kirim request AJAX
    fetch('admin/auto_save_rekam.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'id_janji=' + id_janji
    })
    .then(response => response.json())
    .then(data => {
        if(data.status === 'success') {
            // Tampilkan pesan sukses
            showNotification('success', '✅ ' + data.message);
            
            // Update tampilan tombol
            buttonElement.innerHTML = '✅ Selesai';
            buttonElement.style.backgroundColor = '#218838';
            
            // Update status di tabel secara real-time
            updateStatusInTable(id_janji, 'selesai');
            
            // Refresh data setelah 2 detik
            setTimeout(() => {
                location.reload();
            }, 2000);
            
        } else if(data.status === 'warning') {
            // Jika sudah ada rekam medis
            showNotification('warning', '⚠️ ' + data.message);
            buttonElement.innerHTML = '📋 Sudah diperiksa';
            buttonElement.style.backgroundColor = '#ffc107';
            buttonElement.disabled = true;
            
        } else {
            // Jika error
            showNotification('error', '❌ ' + data.message);
            buttonElement.innerHTML = originalText;
            buttonElement.disabled = false;
            buttonElement.style.backgroundColor = '#28a745';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('error', '❌ Terjadi kesalahan jaringan');
        buttonElement.innerHTML = originalText;
        buttonElement.disabled = false;
        buttonElement.style.backgroundColor = '#28a745';
    });
}

// Fungsi untuk update status di tabel tanpa refresh
function updateStatusInTable(id_janji, status) {
    // Cari select element dengan data-id yang sesuai
    const selectElement = document.querySelector(`select[data-id="${id_janji}"]`);
    if(selectElement) {
        selectElement.value = status;
        
        // Update warna badge berdasarkan status
        updateStatusBadgeColor(selectElement, status);
    }
}

// Fungsi update warna badge status
function updateStatusBadgeColor(selectElement, status) {
    const statusColors = {
        "menunggu": "#f1c40f",
        "disetujui": "#2ecc71",
        "selesai": "#3498db",
        "batal": "#e74c3c"
    };
    
    selectElement.style.backgroundColor = statusColors[status] || '#f1c40f';
}

// Fungsi untuk menampilkan notifikasi
function showNotification(type, message) {
    // Hapus notifikasi sebelumnya jika ada
    const existingNotification = document.querySelector('.custom-notification');
    if(existingNotification) {
        existingNotification.remove();
    }
    
    // Buat elemen notifikasi
    const notification = document.createElement('div');
    notification.className = `custom-notification notification-${type}`;
    notification.innerHTML = `
        <div style="padding: 15px; margin: 10px; border-radius: 5px; 
                    background-color: ${type === 'success' ? '#d4edda' : 
                                      type === 'warning' ? '#fff3cd' : '#f8d7da'};
                    color: ${type === 'success' ? '#155724' : 
                             type === 'warning' ? '#856404' : '#721c24'};
                    border: 1px solid ${type === 'success' ? '#c3e6cb' : 
                                         type === 'warning' ? '#ffeeba' : '#f5c6cb'};
                    position: fixed; top: 20px; right: 20px; z-index: 9999; 
                    min-width: 300px; box-shadow: 0 4px 12px rgba(0,0,0,0.15);">
            <strong>${type === 'success' ? 'Sukses!' : 
                       type === 'warning' ? 'Peringatan!' : 'Error!'}</strong>
            <br>${message}
            <button onclick="this.parentElement.remove()" 
                    style="float: right; background: none; border: none; 
                           cursor: pointer; font-size: 18px;">×</button>
        </div>
    `;
    
    document.body.appendChild(notification);
    
    // Auto-hide setelah 5 detik untuk sukses/warning
    if(type !== 'error') {
        setTimeout(() => {
            if(notification.parentNode) {
                notification.remove();
            }
        }, 5000);
    }
}

// Tambahkan CSS untuk notifikasi
const style = document.createElement('style');
style.textContent = `
    .custom-notification {
        animation: slideIn 0.3s ease-out;
    }
    
    @keyframes slideIn {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
`;
document.head.appendChild(style);
</script>


<style>
    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        justify-content: center;
        align-items: center;
        z-index: 999;
    }

    .modal.show {
        display: flex;
    }

    .modal-content {
        background: #fff;
        padding: 20px;
        border-radius: 10px;
        width: 400px;
        position: relative;
    }

    .close {
        position: absolute;
        top: 10px;
        right: 10px;
        cursor: pointer;
        font-size: 20px;
    }

    .full {
        width: 100%;
        margin-top: 10px;
    }
</style>

