<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>

<?php
require_once("../includes/db_connect.php"); 

$query = "SELECT * FROM stok ORDER BY id DESC";
$result = $conn->query($query);
?>


<div class="page-stok">
    <h2>📦 Kelola Stok</h2>
    <p>Kelola alat dan bahan medis agar selalu siap digunakan! 🪥✨</p>

    <div class="stok-container">
        <!-- Form Tambah Stok -->
        <div class="stok-form">
            <h3><i class="bx bx-plus-medical"></i> Tambah Barang</h3>
            <form id="formStok" action="./stok_action.php">
                <input type="hidden" id="stok_id" name="stok_id">

                <label>Nama Barang:</label>
                <input type="text" name="nama_barang" id="nama_barang" required>

                <label>Kategori:</label>
                <select name="kategori" id="kategori" required>
                    <option value="">Pilih kategori...</option>
                    <option value="Obat">Obat</option>
                    <option value="Alat">Alat</option>
                    <option value="Perlengkapan">Perlengkapan</option>
                </select>

                <label>Jumlah:</label>
                <input type="number" name="jumlah" id="jumlah" required>

                <label>Satuan:</label>
                <input type="text" name="satuan" id="satuan" required>

                <label>Kadaluarsa:</label>
                <input type="date" name="exp_date" id="exp_date">

                <button type="submit" class="btn-save" id="btnSubmit">
                    <i class="bx bx-save"></i> Simpan
                </button>
            </form>
        </div>

        <!-- Daftar Stok -->
        <div class="stok-list">
            <h3><i class="bx bx-list-ul"></i> Daftar Barang</h3>
            <table>
                <thead>
                    <tr>
                        <th>Nama Barang</th>
                        <th>Kategori</th>
                        <th>Jumlah</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody id="dataStok">
                    <?php
                    // Fetch the next row of a result set as an associative array
                    while ($res = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td>".$res['nama_barang']."</td>";
                        echo "<td>".$res['kategori']."</td>";
                        echo "<td>".$res['jumlah']."</td>";	
                        echo "<td><a href=\"proses_stok/edit.php?id=$res[id]\">Edit</a> | 
                        <a href=\"delete.php?id=$res[id]\" onClick=\"return confirm('Are you sure you want to delete?')\">Delete</a></td>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="../assets/js/stok_crud.js"></script>
