<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>

<div class="page-pembayaran">
    <h2>💰 Pembayaran Pasien</h2>
    <p>Kelola transaksi pasien dengan cepat dan mudah. Scan QR untuk menyelesaikan pembayaran.</p>

    <!-- Daftar Tagihan -->
    <div class="tagihan-table">
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Pasien</th>
                    <th>Tanggal</th>
                    <th>Total (Rp)</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody id="listTagihan">
                <tr>
                    <td>1</td>
                    <td>Budi Kecil</td>
                    <td>11 Okt 2025</td>
                    <td>150.000</td>
                    <td><span class="status pending">Belum Bayar</span></td>
                    <td>
                        <button class="btn-qr" data-nama="Budi Kecil" data-nominal="150000">
                            <i class="bx bx-qr"></i> QR
                        </button>
                        <button class="btn-lunas"><i class="bx bx-check"></i> Lunas</button>
                    </td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>Lala Ceria</td>
                    <td>11 Okt 2025</td>
                    <td>200.000</td>
                    <td><span class="status done">Lunas</span></td>
                    <td>
                        <button class="btn-disabled" disabled><i class="bx bx-qr"></i> QR</button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Modal QR -->
    <div class="modal" id="modalQR">
        <div class="modal-content">
            <h3>QR Pembayaran</h3>
            <canvas id="qrCanvas"></canvas>
            <p id="qrText"></p>
            <button class="btn-close">Tutup</button>
        </div>
    </div>
</div>

<!-- Script -->
<script src="https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js"></script>
<script>
    const modal = document.getElementById('modalQR');
    const canvas = document.getElementById('qrCanvas');
    const qrText = document.getElementById('qrText');

    // Buka QR modal
    document.querySelectorAll('.btn-qr').forEach(btn => {
        btn.addEventListener('click', () => {
            const nama = btn.dataset.nama;
            const nominal = btn.dataset.nominal;
            const kodeTransaksi = "TX-" + Math.floor(100000 + Math.random() * 900000);
            const dataQR = `Nama: ${nama}\nNominal: Rp${nominal}\nKode: ${kodeTransaksi}`;
            qrText.textContent = `Kode: ${kodeTransaksi}`;
            QRCode.toCanvas(canvas, dataQR, {
                width: 180,
                color: {
                    dark: "#2E8BFD",
                    light: "#ffffff"
                }
            });
            modal.classList.add('show');
        });
    });

    // Tutup modal
    document.querySelector('.btn-close').addEventListener('click', () => {
        modal.classList.remove('show');
    });

    // Tombol lunas
    document.querySelectorAll('.btn-lunas').forEach(btn => {
        btn.addEventListener('click', () => {
            const row = btn.closest('tr');
            row.querySelector('.status').textContent = "Lunas";
            row.querySelector('.status').className = "status done";
            btn.remove();
        });
    });
</script>
