<?php
require_once("../../includes/db_connect.php");

// --- Jika ambil data pasien berdasarkan ID (GET) ---
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    $stmt = $conn->prepare("SELECT * FROM data_diri_pasien WHERE id_pasien = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    header('Content-Type: application/json');
    echo json_encode($data ?: []);
    exit;
}

// --- Jika update data pasien (POST) ---
if (isset($_POST['update'])) {
    $id = $_POST['id_pasien'];
    $nama = $_POST['nama_pasien'];
    $tgl = $_POST['tgl_lahir'];
    $jk = $_POST['jenis_kelamin'];
    $email = $_POST['email'];
    $telp = $_POST['no_telp'];
    $alamat = $_POST['alamat'];

    $stmt = $conn->prepare("UPDATE data_diri_pasien 
                            SET nama_pasien = ?, tgl_lahir = ?, jenis_kelamin = ?, 
                                email = ?, no_telp = ?, alamat = ?
                            WHERE id_pasien = ?");
    $stmt->bind_param("ssssssi", $nama, $tgl, $jk, $email, $telp, $alamat, $id);

    if ($stmt->execute()) {
        echo "success";
    } else {
        echo "error";
    }
    exit;
}
?>
