<?php
session_start();
if(!isset($_SESSION['id_admin'])){
    header("Location: ../login_admin.php");
    exit();
}

require_once("../includes/db_connect.php");

// Cek apakah form telah disubmit
if($_SERVER['REQUEST_METHOD'] == 'POST'){
    // Ambil data dari form
    $id_pasien = intval($_POST['id_pasien']);
    $id_layanan = intval($_POST['id_layanan']);
    $id_pegawai = intval($_POST['id_pegawai']);
    $keluhan = trim($_POST['keluhan']);
    $tindakan = trim($_POST['tindakan']);
    $hasil = trim($_POST['hasil']);
    $tanggal_periksa = $_POST['tanggal_periksa'];
    $id_janji = isset($_POST['id_janji']) ? intval($_POST['id_janji']) : 0;
    
    // Validasi input
    if(empty($keluhan) || empty($tindakan) || empty($hasil) || empty($tanggal_periksa)){
        header("Location: rekam_medis.php?id_janji=" . $id_janji . "&error=empty");
        exit();
    }
    
    // Persiapan query INSERT
    $query = "INSERT INTO rekam_medis 
              (id_pasien, id_layanan, id_pegawai, keluhan, tindakan, hasil, tanggal_periksa, tanggal_input) 
              VALUES (?, ?, ?, ?, ?, ?, ?, NOW())";
    
    $stmt = $conn->prepare($query);
    
    if($stmt === false){
        die("Error prepare statement: " . $conn->error);
    }
    
    // Bind parameter
    $stmt->bind_param("iiissss", 
        $id_pasien, 
        $id_layanan, 
        $id_pegawai, 
        $keluhan, 
        $tindakan, 
        $hasil, 
        $tanggal_periksa
    );
    
    // Eksekusi query
    if($stmt->execute()){
        // Jika ada id_janji, update status janji menjadi "selesai"
        if($id_janji > 0){
            $update_query = "UPDATE janji_temu SET status = 'selesai' WHERE id_janji = ?";
            $update_stmt = $conn->prepare($update_query);
            $update_stmt->bind_param("i", $id_janji);
            $update_stmt->execute();
            $update_stmt->close();
        }
        
        $stmt->close();
        header("Location: rekam_medis.php?id_janji=" . $id_janji . "&success=1");
        exit();
    } else {
        $stmt->close();
        header("Location: rekam_medis.php?id_janji=" . $id_janji . "&error=db");
        exit();
    }
} else {
    // Jika tidak melalui POST, redirect ke halaman janji
    header("Location: kelola_janji.php");
    exit();
}
?>