<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>

<?php
    require_once("../includes/db_connect.php"); 

    $query = "SELECT * FROM template_notifikasi ORDER BY id_tn DESC";
    $result = $conn->query($query);
?>

<div class="page-template-notif">
    <h2>🔔 Template Notifikasi</h2>
    <p>Atur pesan otomatis untuk pasien kecil kita agar tetap tersenyum ceria! 😄💌</p>

    <div class="notif-container">
        <!-- Form Tambah/Edit -->
        <div class="notif-form">
            <h3><i class="bx bx-edit-alt"></i> Buat / Edit Template</h3>
            <form id="formNotif">
                <input type="hidden" name="id" id="notif_id">

                <label>Judul Pesan:</label>
                <input type="text" id="judul" name="judul" required>

                <label>Kategori:</label>
                <select name="kategori" id="kategori">
                    <option value="Ulang Tahun">🎂 Ulang Tahun</option>
                    <option value="Pengingat Kontrol">🦷 Pengingat Kontrol</option>
                    <option value="Informasi">📢 Informasi</option>
                    <option value="Lainnya">💬 Lainnya</option>
                </select>

                <label>Isi Pesan:</label>
                <textarea id="isi" name="isi" rows="4" placeholder="Tulis pesan di sini..."></textarea>

                <button type="submit" class="btn-save"><i class="bx bx-save"></i> Simpan</button>
            </form>
        </div>

        <!-- Daftar Template -->
        <div class="notif-list">
            <h3><i class="bx bx-list-ul"></i> Daftar Template</h3>
            <table>
                <thead>
                    <tr>
                        <th>Judul</th>
                        <th>Kategori</th>
                        <th>Isi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody id="dataNotif">
                    <?php
                    // Fetch the next row of a result set as an associative array
                    while ($res = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td>".$res['judul']."</td>";
                        echo "<td>".$res['isi']."</td>";
                        echo "<td>".$res['kategori']."</td>";	
                        echo "<td><a href=\"proses_stok/edit.php?id=$res[id_tn]\">Edit</a> | 
                        <a href=\"delete.php?id=$res[id_tn]\" onClick=\"return confirm('Are you sure you want to delete?')\">Delete</a></td>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="../assets/js/template_notifikasi_crud.js"></script>
