document.addEventListener("DOMContentLoaded", () => {
  loadPegawai();

  const form = document.getElementById("formPegawai");

  form.addEventListener("submit", (e) => {
    e.preventDefault();

    const formData = new FormData(form);
    formData.append("aksi", "tambah");

    fetch("action_pegawai.php", {
      method: "POST",
      body: formData,
    })
      .then((res) => res.text())
      .then((res) => {
        if (res.includes("success")) {
          alert("✅ Data pegawai berhasil disimpan!");
          form.reset();
          loadPegawai();
        } else {
          alert("❌ Gagal menyimpan data!\n\n" + res);
        }
      });
  });
});

function loadPegawai() {
  const formData = new FormData();
  formData.append("aksi", "tampil");

  fetch("action_pegawai.php", {
    method: "POST",
    body: formData,
  })
    .then((res) => res.json())
    .then((data) => {
      const tbody = document.getElementById("tablePegawai");
      tbody.innerHTML = "";
      data.forEach((p, i) => {
        tbody.innerHTML += `
                <tr>
                    <td>${i + 1}</td>
                    <td>${p.nama_pegawai}</td>
                    <td>${p.email}</td>
                    <td>${p.no_telp}</td>
                    <td>${p.jabatan}</td>
                    <td>
                        <button onclick="hapusPegawai(${
                          p.id_pegawai
                        })">🗑️</button>
                    </td>
                </tr>
            `;
      });
    });
}

function hapusPegawai(id) {
  if (confirm("Hapus data ini?")) {
    const formData = new FormData();
    formData.append("aksi", "hapus");
    formData.append("id", id);

    fetch("action_pegawai.php", {
      method: "POST",
      body: formData,
    })
      .then((res) => res.text())
      .then(() => loadPegawai());
  }
}
