document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("formStok");
  const tbody = document.getElementById("dataStok");
  const btnSubmit = document.getElementById("btnSubmit");

  loadStok();

  // Ambil data stok
  function loadStok() {
    fetch("../admin/stok_action.php?action=read")
      .then((res) => res.json())
      .then((data) => {
        tbody.innerHTML = "";
        if (data.length === 0) {
          tbody.innerHTML = `<tr><td colspan="7" align="center">Belum ada data stok 🦷</td></tr>`;
        } else {
          data.forEach((item, index) => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
              <td>${index + 1}</td>
              <td>${item.nama_barang}</td>
              <td>${item.kategori}</td>
              <td>${item.jumlah}</td>
              <td>${item.satuan}</td>
              <td>${item.exp_date ?? "-"}</td>
              <td>
                <button class="btn-edit" data-id="${
                  item.id
                }"><i class="bx bx-edit"></i></button>
                <button class="btn-delete" data-id="${
                  item.id
                }"><i class="bx bx-trash"></i></button>
              </td>
            `;
            tbody.appendChild(tr);
          });
        }
      });
  }

  // Tambah / Update stok
  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const formData = new FormData(form);
    fetch("../admin/stok_action.php?action=save", {
      method: "POST",
      body: formData,
    })
      .then((res) => res.text())
      .then((msg) => {
        alert(msg);
        form.reset();
        loadStok();
      });
  });

  // Edit
  tbody.addEventListener("click", (e) => {
    if (e.target.closest(".btn-edit")) {
      const id = e.target.closest(".btn-edit").dataset.id;
      fetch(`../admin/stok_action.php?action=get&id=${id}`)
        .then((res) => res.json())
        .then((item) => {
          document.getElementById("stok_id").value = item.id;
          document.getElementById("nama_barang").value = item.nama_barang;
          document.getElementById("kategori").value = item.kategori;
          document.getElementById("jumlah").value = item.jumlah;
          document.getElementById("satuan").value = item.satuan;
          document.getElementById("exp_date").value = item.exp_date;
          btnSubmit.innerHTML = `<i class="bx bx-refresh"></i> Update`;
        });
    }

    // Hapus
    if (e.target.closest(".btn-delete")) {
      const id = e.target.closest(".btn-delete").dataset.id;
      if (confirm("Yakin ingin menghapus data ini?")) {
        fetch(`../admin/stok_action.php?action=delete&id=${id}`)
          .then((res) => res.text())
          .then((msg) => {
            alert(msg);
            loadStok();
          });
      }
    }
  });
});
