<?php
require_once("db_connect.php");

$aksi = $_POST['aksi'] ?? null;

// === 1️⃣ TAMPIL SEMUA JANJI (JOIN nama pasien & layanan)
if ($aksi == 'tampil') {
    $query = "SELECT j.*, p.nama_pasien, l.nama_layanan 
              FROM janji_temu j
              JOIN data_diri_pasien p ON j.id_pasien = p.id_pasien
              JOIN layanan l ON j.id_layanan = l.id_layanan
              ORDER BY j.tanggal_janji DESC";
    $result = $conn->query($query);
    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

// === 2️⃣ LIST PASIEN (untuk dropdown tambah/edit)
if ($aksi == 'list_pasien') {
    $result = $conn->query("SELECT id_pasien, nama_pasien AS nama FROM data_diri_pasien ORDER BY nama_pasien ASC");
    $data = [];
    while ($row = $result->fetch_assoc()) $data[] = $row;
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

// === 3️⃣ LIST LAYANAN (untuk dropdown tambah)
if ($aksi == 'list_layanan') {
    $result = $conn->query("SELECT id_layanan, nama_layanan FROM layanan ORDER BY nama_layanan ASC");
    $data = [];
    while ($row = $result->fetch_assoc()) $data[] = $row;
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

// === 4️⃣ TAMBAH JANJI
if ($aksi == 'tambah') {
    $id_pasien = $_POST['id_pasien'];
    $id_layanan = $_POST['id_layanan'];
    $tanggal = $_POST['tanggal_janji'];
    $jam = $_POST['jam_janji'];
    $catatan = $_POST['catatan'] ?? '';

    $stmt = $conn->prepare("INSERT INTO janji_temu (id_pasien, id_layanan, tanggal_janji, jam_janji, status, catatan, dibuat_pada) 
                            VALUES (?, ?, ?, ?, 'Menunggu', ?, NOW())");
    $stmt->bind_param("iisss", $id_pasien, $id_layanan, $tanggal, $jam, $catatan);

    echo $stmt->execute() ? "success" : "error";
    exit;
}

// === 5️⃣ EDIT JANJI
if ($aksi == 'edit') {
    $id = $_POST['id'];
    $tanggal = $_POST['tanggal_janji'];
    $jam = $_POST['jam_janji'];
    $status = $_POST['status'] ?? 'Menunggu';
    $catatan = $_POST['catatan'] ?? '';

    $stmt = $conn->prepare("UPDATE janji_temu 
                            SET tanggal_janji=?, jam_janji=?, status=?, catatan=? 
                            WHERE id_janji=?");
    $stmt->bind_param("ssssi", $tanggal, $jam, $status, $catatan, $id);

    echo $stmt->execute() ? "success" : "error";
    exit;
}

// === 6️⃣ HAPUS JANJI
if ($aksi == 'hapus') {
    $id = $_POST['id'];
    $stmt = $conn->prepare("DELETE FROM janji_temu WHERE id_janji=?");
    $stmt->bind_param("i", $id);
    echo $stmt->execute() ? "success" : "error";
    exit;
}

// === 7️⃣ DEFAULT: AKSI TIDAK DIKENAL
echo "invalid";
?>
