<?php
session_start();
include 'db_connect.php'; // pastikan nama file sesuai, kamu tadi pakai db_connect.php

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    // Hash password pakai SHA512 (harus sama dengan yang di database)
    $hashed_password = hash('sha512', $password);

    // Cek user di database
    $sql = "SELECT * FROM admin WHERE username = ? AND password = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $username, $hashed_password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();

        // Simpan session login
        $_SESSION['id_admin'] = $row['id_admin'];
        $_SESSION['username'] = $row['username'];
        $_SESSION['nama_admin'] = $row['nama_admin'];
        $_SESSION['email_admin'] = $row['email'];

        header("Location: ../admin_layout.php");
        exit();
    } else {
        // Login gagal
        echo "<script>
            alert('Username atau password salah!');
            window.location.href = '../login_admin.php';
        </script>";
        exit();
    }
} else {
    header("Location: ../login_admin.php");
    exit();
}
?>
