<?php
session_start();
include 'db_connect.php'; // pastikan file ini sesuai path

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Hash password pakai SHA512 (harus sama seperti saat insert)
    $hashed_password = hash('sha256', $password);

    // Cek akun pasien berdasarkan email & password
    $sql = "SELECT * FROM acc_pasien WHERE email = ? AND password = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $email, $hashed_password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();

        // Simpan data session pasien
        $_SESSION['id_pasien'] = $row['id_pasien'];
        $_SESSION['email_pasien'] = $row['email'];
        $_SESSION['tanggal_daftar'] = $row['tanggal_daftar'];

        // Redirect ke dashboard pasien
        header("Location: ../pasien_layout.php");
        exit();
    } else {
        // Jika login gagal
        echo "<script>
            alert('Email atau password salah!');
            window.location.href = '../login_pasien.php';
        </script>";
        exit();
    }
} else {
    // Jika akses langsung tanpa POST
    header("Location: ../login_pasien.php");
    exit();
}
?>
