<?php
require_once("../includes/db_connect.php");
session_start();

// Pastikan pasien sudah login
if (!isset($_SESSION['id_pasien'])) {
    echo "<script>alert('Silakan login terlebih dahulu!'); window.location.href='../login.php';</script>";
    exit();
}

$id_pasien = $_SESSION['id_pasien'];

// Ambil daftar layanan untuk dropdown
$qLayanan = $conn->query("SELECT id_layanan, nama_layanan FROM jenis_layanan ORDER BY nama_layanan ASC");

// Ambil riwayat janji temu pasien
$qJanji = $conn->prepare("
    SELECT j.*, l.nama_layanan 
    FROM janji_temu j
    LEFT JOIN jenis_layanan l ON j.id_layanan = l.id_layanan
    WHERE j.id_pasien = ?
    ORDER BY j.tanggal_janji DESC
");
$qJanji->bind_param("i", $id_pasien);
$qJanji->execute();
$resJanji = $qJanji->get_result();
?>

<div class="page-janji">
    <h2>🦷 Buat Janji Temu</h2>
    <p>Hai <b>Adik Ceria!</b> Silakan isi data di bawah ini untuk membuat janji ke dokter gigi ya 😄</p>

    <div class="janji-container">
        <div class="form-section">
            <h3>Buat Janji Baru</h3>
            <form action="pasien/proses_janji_pasien/tambah.php" method="POST">
                <label for="tanggal">Tanggal Kunjungan</label>
                <input type="date" id="tanggal" name="tanggal" required>

                <label for="layanan">Jenis Layanan</label>
                <select id="layanan" name="id_layanan" required>
                    <option value="">-- Pilih Layanan --</option>
                    <?php while ($row = $qLayanan->fetch_assoc()) { ?>
                    <option value="<?= $row['id_layanan'] ?>"><?= htmlspecialchars($row['nama_layanan']) ?></option>
                    <?php } ?>
                </select>

                <label for="catatan">Catatan (opsional)</label>
                <textarea id="catatan" name="catatan"
                    placeholder="Misalnya: gigi saya sakit sebelah kiri..."></textarea>

                <button type="submit" class="btn-ajukan">💌 Ajukan Janji</button>
            </form>
        </div>

        <div class="riwayat-section">
            <h3>Riwayat Janji Temu</h3>
            <table>
                <thead>
                    <tr>
                        <th>Tanggal</th>
                        <th>Layanan</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resJanji->num_rows > 0): ?>
                    <?php while ($row = $resJanji->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['tanggal_janji']) ?></td>
                        <td><?= htmlspecialchars($row['nama_layanan']) ?></td>
                        <td>
                            <?php if ($row['status'] == 'menunggu'): ?>
                            <span style="color: orange;">Menunggu</span>
                            <?php elseif ($row['status'] == 'disetujui'): ?>
                            <span style="color: green;">Disetujui</span>
                            <?php elseif ($row['status'] == 'ditolak'): ?>
                            <span style="color: red;">Ditolak</span>
                            <?php else: ?>
                            <?= htmlspecialchars($row['status']) ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($row['status'] == 'menunggu'): ?>
                            <a href="pasien/proses_janji_pasien/delete.php?id=<?= $row['id_janji'] ?>"
                                onclick="return confirm('Yakin ingin menghapus janji ini?')" class="btn-hapus">❌
                                Hapus</a>
                            <?php else: ?>
                            <em>-</em>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="5" align="center">Belum ada janji temu.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
$qJanji->close();
$conn->close();
?>
