<section class="pesan-container">
    <h2>📬 Pesan & Notifikasi Anda</h2>
    <div id="pesan-list" class="pesan-list">
        <!-- Pesan akan dimuat lewat PHP atau AJAX -->
        <?php
      include '../includes/db_connect.php';
      session_start();
      $id_pasien = $_SESSION['id_pasien'];
      $query = "SELECT * FROM pesan_notifikasi WHERE id_pasien = $id_pasien ORDER BY tanggal_kirim DESC";
      $result = mysqli_query($conn, $query);
      if (mysqli_num_rows($result) > 0) {
          while ($row = mysqli_fetch_assoc($result)) {
              echo "
              <div class='pesan-card ".($row['status']=='belum_dibaca' ? 'baru' : '')."'>
                  <h4>{$row['judul']}</h4>
                  <p>{$row['isi']}</p>
                  <span class='tanggal'>".date('d M Y H:i', strtotime($row['tanggal_kirim']))."</span>
              </div>";
          }
      } else {
          echo "<p>Tidak ada pesan baru.</p>";
      }
    ?>
    </div>
</section>

<style>
    .pesan-container {
        padding: 20px;
        background: #f0fbff;
        border-radius: 12px;
        animation: fadeIn 0.6s ease;
    }

    .pesan-container h2 {
        color: #333;
        margin-bottom: 15px;
    }

    .pesan-list {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .pesan-card {
        background: #fff;
        border-radius: 10px;
        padding: 15px;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s;
    }

    .pesan-card:hover {
        transform: scale(1.02);
    }

    .pesan-card.baru {
        border-left: 6px solid #57c5b6;
    }

    .tanggal {
        font-size: 12px;
        color: #888;
    }

    @keyframes fadeIn{from {
        opacity: 0;
        transform: translateY(10px);
    }

    to {
        opacity: 1;
        transform: translateY(0);
    }
    }
</style>
