<?php
session_start();
include '../../includes/db_connect.php';

$id_pasien = $_SESSION['id_pasien'] ?? 0;
if ($id_pasien == 0) {
    echo json_encode(["error" => "Belum login"]);
    exit;
}

// Cek apakah ada antrian baru
$query = "
    SELECT COUNT(*) as count 
    FROM antrian a
    JOIN janji_temu j ON a.id_janji = j.id_janji
    WHERE j.id_pasien = ?
    AND a.created_at > DATE_SUB(NOW(), INTERVAL 5 MINUTE)
";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id_pasien);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

echo json_encode([
    "hasNewData" => $data['count'] > 0,
    "timestamp" => date('Y-m-d H:i:s')
]);
?>