<?php
session_start();
if (!isset($_SESSION['id_pasien'])) {
    header("Location: login_pasien.php");
    exit();
}
?>
<?php 
    include 'includes/db_connect.php'; 
    
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Klinik Gigi Tumbuh Kembang Pratama - pasien</title>

    <!-- Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/pasien_theme.css">
</head>

<body>
    <div class="layout">
        <!-- Sidebar -->
        <?php include 'sidebar_pasien.php'; ?>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Navbar -->
            <?php include 'navbar_pasien.php'; ?>

            <!-- Dynamic Content -->
            <section id="content-area">
                <h2>Selamat Datang, nama pasien 👋</h2>
                <p>Pilih menu di sidebar untuk mulai mengelola data klinik.</p>
            </section>

            <!-- Footer -->
            <footer class="footer">
                <p>© 2025 Klinik Tumbuh Kembang Pratama | Dibuat dengan 💙 oleh Tim Kelompok 3</p>
            </footer>


        </main>
    </div>

    <script>
        // Dropdown profil
        document.getElementById('profileBtn').addEventListener('click', function () {
            document.getElementById('profileDropdown').classList.toggle('show');
        });

        // AJAX navigation
        const links = document.querySelectorAll('.sidebar-menu a');
        const content = document.getElementById('content-area');
        links.forEach(link => {
            link.addEventListener('click', e => {
                e.preventDefault();
                links.forEach(l => l.classList.remove('active'));
                link.classList.add('active');
                fetch(link.dataset.page)
                    .then(res => res.text())
                    .then(data => content.innerHTML = data)
                    .catch(() => content.innerHTML = "<p>Halaman gagal dimuat 😢</p>");
            });
        });
    </script>
</body>

</html>
